/*
cd "C:\Users\te\OneDrive - UW\Monique gender\submission European Journal of Political Economy\revison\Replication_Gender_Feb20"
use countryname_mapping.dta, clear
sort countrycode
save countryname_mapping.dta, replace
*/

clear all


local file "All_pvals_LFPR_Fem_ILO22allyrs_Final" // make sure incomplete is **NOT*** commented out
*local file "All_pvals_Ad_Fert_R22allyrs_Final" // make sure incomplete is **NOT*** commented out
*local file "All_pvals_F_M_LFPR_RATIO22allyrs_Final" // make sure incomplete is **NOT*** commented out
*local file "All_pvals_GII22allyrs_Final" // make sure incomplete is **NOT*** commented out
*local file "All_pvals_Mat_Mort_R_MO22allyrs_Final" // make sure incomplete is **NOT*** commented out
*local file "All_pvals_Prim_Enr_GPI22allyrs_Final" // no incomplete comment out
*local file "All_pvals_Sec_Enr_GPI22allyrs_Final" // no incomplete comment out
*local file "All_pvals_Tert_Enr_GPI22allyrs_Final" // no incomplete comment out


{
/////////////////////////////
///// complete programs first
/////////////////////////////

use "R:\Reina\Replication_Gender_Feb20_pre6_8_12\IMFWP_ResCover_12_v1/`file'.dta" , clear

drop if year==.
cap drop _merge
drop if unique_W == 0

gen programx = .
order countrycode year programx

replace programx = -12 if _n == 1 | ( _n >= 1 & mod(_n - 1, 17) == 0 )
replace programx = -11 if _n == 2 | ( _n >= 2 & mod(_n - 2, 17) == 0 )
replace programx = -10 if _n == 3 | ( _n >= 3 & mod(_n - 3, 17) == 0 )
replace programx = -9 if _n == 4 | ( _n >= 4 & mod(_n - 4, 17) == 0 )
replace programx = -8 if _n == 5 | ( _n >= 5 & mod(_n - 5, 17) == 0 )
replace programx = -7 if _n == 6 | ( _n >= 6 & mod(_n - 6, 17) == 0 )
replace programx = -6 if _n == 7 | ( _n >= 7 & mod(_n - 7, 17) == 0 )
replace programx = -5 if _n == 8 | ( _n >= 8 & mod(_n - 8, 17) == 0 )
replace programx = -4 if _n == 9 | ( _n >= 9 & mod(_n - 9, 17) == 0 )
replace programx = -3 if _n == 10 | ( _n >= 10 & mod(_n - 10, 17) == 0 )
replace programx = -2 if _n == 11 | ( _n >= 11 & mod(_n - 11, 17) == 0 )
replace programx = -1 if _n == 12 | ( _n >= 12 & mod(_n - 12, 17) == 0 )
replace programx = 0 if _n == 13 | ( _n >= 13 & mod(_n - 13, 17) == 0 )
replace programx = 1 if _n == 14 | ( _n >= 14 & mod(_n - 14, 17) == 0 )
replace programx = 2 if _n == 15 | ( _n >= 15 & mod(_n - 15, 17) == 0 )
replace programx = 3 if _n == 16 | ( _n >= 16 & mod(_n - 16, 17) == 0 )
replace programx = 4 if _n == 17 | ( _n >= 17 & mod(_n - 17, 17) == 0 )

order countrycode year programx _Y_treated _Y_synthetic


gen Y_treat_base = _Y_treated if programx == -1
replace Y_treat_base = Y_treat_base[_n-1] if programx == 0
replace Y_treat_base = Y_treat_base[_n+1] if programx == -2
replace Y_treat_base = Y_treat_base[_n+2] if programx == -3
replace Y_treat_base = Y_treat_base[_n+3] if programx == -4
replace Y_treat_base = Y_treat_base[_n+4] if programx == -5
replace Y_treat_base = Y_treat_base[_n+5] if programx == -6
replace Y_treat_base = Y_treat_base[_n+6] if programx == -7
replace Y_treat_base = Y_treat_base[_n+7] if programx == -8
replace Y_treat_base = Y_treat_base[_n+8] if programx == -9
replace Y_treat_base = Y_treat_base[_n+9] if programx == -10
replace Y_treat_base = Y_treat_base[_n+10] if programx == -11
replace Y_treat_base = Y_treat_base[_n+11] if programx == -12
replace Y_treat_base = Y_treat_base[_n-1] if programx == 1
replace Y_treat_base = Y_treat_base[_n-2] if programx == 2
replace Y_treat_base = Y_treat_base[_n-3] if programx == 3
replace Y_treat_base = Y_treat_base[_n-4] if programx == 4



/*
gen Y_treat_base = _Y_treated if programx == 0
replace Y_treat_base = Y_treat_base[_n+1] if programx == -1
replace Y_treat_base = Y_treat_base[_n+2] if programx == -2
replace Y_treat_base = Y_treat_base[_n+3] if programx == -3
replace Y_treat_base = Y_treat_base[_n+4] if programx == -4
replace Y_treat_base = Y_treat_base[_n+5] if programx == -5
replace Y_treat_base = Y_treat_base[_n+6] if programx == -6
replace Y_treat_base = Y_treat_base[_n+7] if programx == -7
replace Y_treat_base = Y_treat_base[_n+8] if programx == -8
replace Y_treat_base = Y_treat_base[_n+9] if programx == -9
replace Y_treat_base = Y_treat_base[_n+10] if programx == -10
replace Y_treat_base = Y_treat_base[_n+11] if programx == -11
replace Y_treat_base = Y_treat_base[_n+12] if programx == -12
replace Y_treat_base = Y_treat_base[_n-1] if programx == 1
replace Y_treat_base = Y_treat_base[_n-2] if programx == 2
replace Y_treat_base = Y_treat_base[_n-3] if programx == 3
replace Y_treat_base = Y_treat_base[_n-4] if programx == 4
*/



*gen gap_norm = gap/Y_treat_base
gen gap_norm = gap

order countrycode year programx _Y_treated Y_treat_base gap_norm

gen long counter = _n

order counter countrycode year programx _Y_treated Y_treat_base gap_norm

order counter countrycode year programx gap_norm p _Y_treated Y_treat_base gap_norm
sort counter

order counter countrycode year programx gap_norm p _Y_treated Y_treat_base gap_norm
keep counter countrycode year programx gap_norm p _Y_treated Y_treat_base gap_norm

gen str10 star = ""
replace star = "***" if p < 0.01
replace star = "**"  if p <= 0.05 & p > 0.01
replace star = "*"  if p <= 0.1 & p > 0.05

gen double gapnormpct = round(gap_norm * 100, 0.01)
*gen double gapnormpct = round(gap_norm, 0.01)
tostring gapnormpct, gen(gapnormpct_str) force
*gen str gappct_sig = gapnormpct_str + "_" + star
gen str gappct_sig = gapnormpct_str + star

gen progyr = year if programx == 0
replace progyr = progyr[_n+1] if programx == -1
replace progyr = progyr[_n+2] if programx == -2
replace progyr = progyr[_n+3] if programx == -3
replace progyr = progyr[_n+4] if programx == -4
replace progyr = progyr[_n+5] if programx == -5
replace progyr = progyr[_n+6] if programx == -6
replace progyr = progyr[_n+7] if programx == -7
replace progyr = progyr[_n+8] if programx == -8
replace progyr = progyr[_n+9] if programx == -9
replace progyr = progyr[_n+10] if programx == -10
replace progyr = progyr[_n+11] if programx == -11
replace progyr = progyr[_n+12] if programx == -12
replace progyr = progyr[_n-1] if programx == 1
replace progyr = progyr[_n-2] if programx == 2
replace progyr = progyr[_n-3] if programx == 3
replace progyr = progyr[_n-4] if programx == 4

order counter countrycode year progyr programx gap_norm p _Y_treated Y_treat_base gap_norm

keep countrycode progyr programx gappct_sig

tostring progyr, gen(progyr_str) force
tostring countrycode, gen(countrycode_str) force

gen str country_year = countrycode_str + "_" + progyr_str

keep country_year programx gappct_sig

save toreshape, replace
use toreshape, clear

*reshape wide age, i(famid)  j(birth)  
*replace country_year = subinstr(country_year, " ", "&", .)
*replace gappct_sig = subinstr(gappct_sig, "_", "&", .)
*replace country_year = subinstr(country_year, "_", "&", .)

tostring programx, gen(programx_str) force
replace programx_str = subinstr(programx_str, "-", "m", .)

ren gappct_sig gappctsig
ren country_year countryyear
ren programx_str program
drop programx
reshape wide gappctsig, i(countryyear) j(program) string

*reshape wide gappct_sig, i(country_year) j(programx_for_j) 

order countryyear	gappctsigm12 gappctsigm11 gappctsigm10 gappctsigm9 gappctsigm8 gappctsigm7 gappctsigm6 gappctsigm5 gappctsigm4	gappctsigm3	gappctsigm2	gappctsigm1	gappctsig0	gappctsig1	gappctsig2	gappctsig3	gappctsig4

split countryyear, parse("_")
rename countryyear1 country
rename countryyear2 progyr
drop countryyear
order country progyr	gappctsigm12 gappctsigm11 gappctsigm10 gappctsigm9 gappctsigm8 gappctsigm7 gappctsigm6 gappctsigm5 gappctsigm4	gappctsigm3	gappctsigm2	gappctsigm1	gappctsig0	gappctsig1	gappctsig2	gappctsig3	gappctsig4

////////
ren country countrycode
sort countrycode
destring countrycode, replace
*merge m:1 countrycode using countryname_mapping.dta
*drop if _merge==2
kountry countrycode, from(imfn) m
drop MARKER
rename NAMES_STD countryname

order countryname progyr gappctsigm12 gappctsigm11 gappctsigm10 gappctsigm9	gappctsigm8 gappctsigm7 gappctsigm6 gappctsigm5  gappctsigm4	gappctsigm3	gappctsigm2	gappctsigm1	gappctsig0	gappctsig1	gappctsig2	gappctsig3	gappctsig4
keep countryname progyr gappctsigm12 gappctsigm11 gappctsigm10 gappctsigm9 gappctsigm8 gappctsigm7 	gappctsigm6 gappctsigm5  gappctsigm4	gappctsigm3	gappctsigm2	gappctsigm1	gappctsig0	gappctsig1	gappctsig2	gappctsig3	gappctsig4

sort progyr countryname
replace countryname = strproper(countryname)

ren gappctsigm12 minus12
ren gappctsigm11 minus11
ren gappctsigm10 minus10
ren gappctsigm9 minus9
ren gappctsigm8 minus8
ren gappctsigm7 minus7
ren gappctsigm6 minus6
ren gappctsigm5 minus5
ren gappctsigm4 minus4
ren gappctsigm3 minus3
ren gappctsigm2 minus2
ren gappctsigm1 minus1
ren gappctsig0 Prog
ren gappctsig1 plus1
ren gappctsig2 plus2
ren gappctsig3 plus3
ren gappctsig4 plus4

destring minus1, replace force

drop if minus1>10
drop if minus1<-10

save "R:\Reina\Replication_Gender_Feb20_pre6_8_12\IMFWP_ResCover_12_v1/`file'complete.dta", replace


}
/////////////////////////////////
* */ comment out for ed data
////////////////////////////////
